def f_rive(LargeMoyLit, VarLit, LargeRiveG, LargeRiveD, NatureRiveG, NatureRiveD):
    """
    F_Rive – Évaluation des rives

    Calcule un score des rives à partir des largeurs moyennes du lit, de la variabilité,
    des largeurs de rive gauche et droite, et de la nature des rives.

    Paramètres :
        LargeMoyLit (float) : Largeur moyenne du lit
        VarLit (int) : Variabilité du lit (1,2,3)
        LargeRiveG (float) : Largeur de la rive gauche
        LargeRiveD (float) : Largeur de la rive droite
        NatureRiveG (int) : Nature rive gauche (1=géré,2=faux,3=aucun)
        NatureRiveD (int) : Nature rive droite (1=géré,2=faux,3=aucun)

    Retour :
        int : Score final arrondi à l'entier le plus proche (0.5 vers le haut)
              ou -10 pour exclusion.
    """

    # Remplacer les valeurs None par 0
    VarLit = 0 if VarLit == None else VarLit
    NatureRiveG = 0 if NatureRiveG == None else NatureRiveG
    NatureRiveD = 0 if NatureRiveD == None else NatureRiveD

    # --- Calcul rive gauche ---
    if LargeRiveG == None or LargeMoyLit == None or LargeMoyLit == 0 or VarLit == 0:
        P_LUferBer = 0
    elif LargeRiveG == 0:
        P_LUferBer = 3
    else:
        if ((VarLit == 1 and ((LargeMoyLit < 2 and LargeRiveG >= 5) 
            or (2 <= LargeMoyLit <= 15 and LargeRiveG >= 10/13*LargeMoyLit + 45/13)
            or (LargeMoyLit > 15 and LargeRiveG >= 15)))
            or (VarLit == 2 and ((LargeMoyLit < 4/3 and LargeRiveG >= 5)
            or (4/3 <= LargeMoyLit <= 10 and LargeRiveG >= 15/13*LargeMoyLit + 45/13)
            or (LargeMoyLit > 10 and LargeRiveG >= 15)))
            or (VarLit == 3 and ((LargeMoyLit < 1 and LargeRiveG >= 5)
            or (1 <= LargeMoyLit <= 15/2 and LargeRiveG >= 20/13*LargeMoyLit + 45/13)
            or (LargeMoyLit > 15/2 and LargeRiveG >= 15)))):
            P_LUferBer = 1
        else:
            P_LUferBer = 2

    # --- Calcul rive droite ---
    if LargeRiveD == None or LargeMoyLit == None or LargeMoyLit == 0 or VarLit == 0:
        P_RUferBer = 0
    elif LargeRiveD == 0:
        P_RUferBer = 3
    else:
        if ((VarLit == 1 and ((LargeMoyLit < 2 and LargeRiveD >= 5) 
            or (2 <= LargeMoyLit <= 15 and LargeRiveD >= 10/13*LargeMoyLit + 45/13)
            or (LargeMoyLit > 15 and LargeRiveD >= 15)))
            or (VarLit == 2 and ((LargeMoyLit < 4/3 and LargeRiveD >= 5)
            or (4/3 <= LargeMoyLit <= 10 and LargeRiveD >= 15/13*LargeMoyLit + 45/13)
            or (LargeMoyLit > 10 and LargeRiveD >= 15)))
            or (VarLit == 3 and ((LargeMoyLit < 1 and LargeRiveD >= 5)
            or (1 <= LargeMoyLit <= 15/2 and LargeRiveD >= 20/13*LargeMoyLit + 45/13)
            or (LargeMoyLit > 15/2 and LargeRiveD >= 15)))):
            P_RUferBer = 1
        else:
            P_RUferBer = 2

    # --- Fonction interne pour calculer le score en fonction de P et Nature ---
    def score_ber(P, Nature):
        if P == 3 or Nature == 3:
            return 3
        elif P == 1:
            return 0 if Nature == 1 else 1.5
        else:  # P == 2
            return 2 if Nature == 1 else 3

    # --- Calcul score final avec cas d'exclusion ---
    if P_LUferBer == 0 or P_RUferBer == 0:
        Punkte = -10
    elif (P_LUferBer < 3 and NatureRiveG == 0) or (P_RUferBer < 3 and NatureRiveD == 0):
        Punkte = -10
    else:
        LUfer = score_ber(P_LUferBer, NatureRiveG)
        RUfer = score_ber(P_RUferBer, NatureRiveD)
        Punkte = (LUfer + RUfer) / 2
        Punkte = int(Punkte + 0.5)  # arrondi 0.5 vers le haut

    return Punkte