import sys
sys.path.append(r"script")  # ajoute ton dossier
# importer la fonction du script f_note.py (répertoire script)
from qgis.utils import iface
from qgis.PyQt import QtWidgets
from qgis.PyQt.QtWidgets import QWidget,QLineEdit,QDialog, QMessageBox
from qgis.core import QgsApplication, QgsFeatureRequest, QgsField, edit
from qgis.gui import QgsAttributeDialog
from f_note import f_note

# A améliorer : trouver une solution  pour rafraichir les valeurs du formulaire courant
# actuellement, on ferme et rouvre le formulaire
# Fermer tous les formulaires ouverts
for w in iface.mainWindow().findChildren(QDialog):
    if w.isActiveWindow():
        w.accept()

layer = iface.activeLayer()
fid = [%idtroncon%]
feat = next(layer.getFeatures(QgsFeatureRequest(fid)))
dialog = iface.getFeatureForm(layer, feat) # Récupère le formulaire
form = dialog.attributeForm()
field_name = 'KlasseGE'


# Récupération des champs de l'entité cliquée
'''
A améliorer : il faudrait reprendre les valeurs courantes du formulaire des dernières saisies, 
même si cela n'a pas été enregistré en base de données
'''
ssTerre = feat['lngMiseSousTerre']
VarLit = feat['lngVariabiliteLargeurLitMouille']
AmLit = feat['lngAmenagementLit']
MatLit = feat['lngMateriauxAmenagementLit']
RenfBergeG = feat['lngRenforcementPiedBergeG']
MatBergeG = feat['lngMateriauxRenforcPiedBergeG']
RenfBergeD = feat['lngRenforcementPiedBergeD']
MatBergeD = feat['lngMateriauxRenforcPiedBergeD']
LargeMoyLit = feat['dblMoyenneLit']
LargeRiveG = feat['dblLargeurMoyenneRiveG']
LargeRiveD = feat['dblLargeurMoyenneRiveD']
NatureRiveG = feat['lngNatureRiveG']
NatureRiveD = feat['lngNatureRiveD']

# Calcul de la note finale
# la fonction f_note provient du fichier "f_note.py" (répertoire "script")
result = f_note(
    ssTerre,
    VarLit, AmLit, MatLit,
    RenfBergeG, MatBergeG, RenfBergeD, MatBergeD,
    LargeMoyLit, LargeRiveG, LargeRiveD, NatureRiveG, NatureRiveD
)
# Vérifier si des modifications sont en cours sur la couche 
# à améliorer : ne voit pas les dernières modifications faites sur le forumulaire
# pouvoir demander à l'utilisateur de sauver les modifications en cours si oui, il continue, si non l'action se ferme
if layer.isEditable() and layer.editBuffer().isModified():
    warn = "Attention, les modifications en cours ne seront pas sauvegardées"
    QMessageBox.warning(None, "Avertissement", warn)
else:
   pass

msg = f"La note de classification calculée est : {result} \n"

# contrôler si la couche n'est pas en lecture seule
if not layer.readOnly():
    if not layer.isEditable(): # vérifier si le mode édition est avtivé ou pas
        '''
        with edit(layer):
            feat[field_name] = result
            layer.updateFeature(feat)
        '''
        layer.startEditing() # ouvrir une session d'édition
    feat[field_name] = result
    layer.updateFeature(feat)

    msg += "\n" + f"identifiant objet : {fid}"
    msg += "\n" + f"Le résultat a été enregistré dans l\'attribut {field_name}"
    QtWidgets.QMessageBox.information(None, "Résultat de la note ",msg)
   
    #field = dialog.findChild(QLineEdit, field_name)
    #field.setText(str(result))
    #form.changeAttribute(field_name,str(result))
    form.setFeature(feat)
    form.refreshFeature()
    dialog.show() # ouvrir le formulaire
    
    #iface.openFeatureForm(layer, feat) - fonction pour ouvrir le formulaire directement
else:
    msg += "\n" + "Sauvegarde impossible, cette couche n’est pas éditable (lecture seule)"
    QtWidgets.QMessageBox.critical(None, "Erreur", msg)
    #raise Exception("Layer non éditable")
