def f_buk(RenfBergeG: int, MatBergeG: int, RenfBergeD: int, MatBergeD: int) -> int:
    """
    F_Buk – Renforcement du pied de berge

    Calcule un score de renforcement du pied de berge en fonction des
    valeurs de RenfBergeG, MatBergeG, RenfBergeD et MatBergeD.

    Règles principales :
    - Si l’un des codes de renforcement = 0 → -10 (exclusion).
    - Si renforcement ≠ 1 et matériau = 0 → -10 (incohérence).
    - Sinon, un score partiel est calculé pour chaque berge :
        * Renforcement 1–2 → 0
        * Renforcement 3 → 0.5 (perméable) ou 1 (étanche)
        * Renforcement 4 → 1.5 (perméable) ou 2 (étanche)
        * Renforcement >4 → 2.5 (perméable) ou 3 (étanche)
    - Score final = moyenne des deux berges, arrondie à l’entier le plus proche
      (0.5 arrondi vers le haut).

    Retour :
        Un entier représentant la note F_Buk.
    """

    # Remplacer les valeurs None par 0
    RenfBergeG = 0 if RenfBergeG == None else RenfBergeG
    MatBergeG  = 0 if MatBergeG == None else MatBergeG
    RenfBergeD = 0 if RenfBergeD == None else RenfBergeD
    MatBergeD  = 0 if MatBergeD == None else MatBergeD

    # Cas d'exclusion
    if RenfBergeG == 0 or RenfBergeD == 0:
        return -10
    if (RenfBergeG != 1 and MatBergeG == 0) or (RenfBergeD != 1 and MatBergeD == 0):
        return -10

    # ---- Côté gauche ----
    if RenfBergeG in (1, 2):
        LBuk = 0
    elif RenfBergeG == 3:
        LBuk = 0.5 if 1 <= MatBergeG <= 3 else 1
    elif RenfBergeG == 4:
        LBuk = 1.5 if 1 <= MatBergeG <= 3 else 2
    else:
        LBuk = 2.5 if 1 <= MatBergeG <= 3 else 3

    # ---- Côté droit ----
    if RenfBergeD in (1, 2):
        RBuk = 0
    elif RenfBergeD == 3:
        RBuk = 0.5 if 1 <= MatBergeD <= 3 else 1
    elif RenfBergeD == 4:
        RBuk = 1.5 if 1 <= MatBergeD <= 3 else 2
    else:
        RBuk = 2.5 if 1 <= MatBergeD <= 3 else 3

    # ---- Moyenne et arrondi ----
    Punkte = (LBuk + RBuk) / 2

    return int(Punkte + 0.5)  # arrondi "0.5 vers le haut"