def f_amlit(AmLit: int, MatLit: int) -> int:
    """
    F_AmLit – Aménagement du fond du lit (Sohle)

    Calcule un score lié à l’aménagement du fond du lit en fonction de 
    AmLit (intensité d’aménagement) et MatLit (type de matériau).

    Paramètres :
        AmLit (int) : Niveau d’aménagement du fond de lit
            - 0 → non défini (exclusion)
            - 1 → 0 % aménagé
            - 2 → < 10 % aménagé
            - 3 → 10–30 % aménagé
            - >3 → >30 % aménagé
        MatLit (int) : Matériau du lit
            - 0 → non défini
            - 1 → perméable
            - autres → étanche

    Retour :
        int : Score F_AmLit, ou -10 pour exclusion

    Exemples :
        f_amlit(0, 1) → -10
        f_amlit(2, 3) → 1
        f_amlit(4, 1) → 2
        f_amlit(4, 5) → 3
    """

    # Normalisation des valeurs None
    if AmLit == None:
        AmLit = 0
    if MatLit == None:
        MatLit = 0

    # Attribution du score
    if AmLit == 0 or (AmLit > 3 and MatLit == 0):
        return -10
    elif AmLit == 1:
        return 0
    elif AmLit == 2:
        return 1
    elif AmLit == 3:
        return 2
    elif AmLit > 3:
        return 2 if MatLit == 1 else 3
    else:
        return -10  # sécurité