from qgis.utils import iface
from qgis.PyQt import QtWidgets
from qgis.PyQt.QtWidgets import QWidget,QLineEdit,QDialog, QMessageBox
from qgis.core import QgsApplication, QgsFeatureRequest, QgsField, edit
from qgis.gui import QgsAttributeDialog

# A améliorer : trouver une solution  pour rafraichir les valeurs du formulaire courant
# actuellement, on ferme et rouvre le formulaire
# Fermer tous les formulaires ouverts
for w in iface.mainWindow().findChildren(QDialog):
    if w.isActiveWindow():
        w.accept()

layer = iface.activeLayer()
fid = [%idtroncon%]
feat = next(layer.getFeatures(QgsFeatureRequest(fid)))
dialog = iface.getFeatureForm(layer, feat)   # Récupère le formulaire
form = dialog.attributeForm()
field_name = 'KlasseGE'

if layer.isEditable() and layer.editBuffer().isModified():
    warn = "Attention, les modifications en cours ne seront pas sauvegardées"
    QMessageBox.warning(None, "Avertissement", warn)
else:
   pass

result = [%f_note( "lngMiseSousTerre" ,
f_varlit( "lngVariabiliteLargeurLitMouille" ),
f_amlit("lngAmenagementLit" , "lngMateriauxAmenagementLit"),
f_buk("lngRenforcementPiedBergeG" ,  "lngMateriauxRenforcPiedBergeG" , "lngRenforcementPiedBergeD" , "lngMateriauxRenforcPiedBergeD" ),
f_rive( "dblMoyenneLit" , "lngVariabiliteLargeurLitMouille" , "dblLargeurMoyenneRiveG" , "dblLargeurMoyenneRiveD" , "lngNatureRiveG" , "lngNatureRiveD" ))%]

msg = f"La note de classification calculée est : {result} \n"

if not layer.readOnly():
    if not layer.isEditable():
        '''
        with edit(layer):
            feat[field_name] = result
            layer.updateFeature(feat)
        '''
        layer.startEditing() # ouvrir une session d'édition
    feat[field_name] = result
    layer.updateFeature(feat)

    msg += "\n" + f"identifiant objet : {fid}"
    msg += "\n" + f"Le résultat a été enregistré dans l\'attribut {field_name}"
    QtWidgets.QMessageBox.information(None, "Résultat de la note ",msg)
   
    '''
    # --- Mise à jour du formulaire ouvert si existant ---
    widget = dialog.findChild(QtWidgets.QWidget, field_name)
    QtWidgets.QMessageBox.information(None, "DEBUG", f"Form widget récupéré : {widget}")
    if widget:
        # Déterminer le type de widget
        widget_type = widget.metaObject().className()
        # Récupérer la valeur actuelle selon le type
        if hasattr(widget, "value"):  # QSpinBox, QDoubleSpinBox
            current_value = widget.value()
        elif hasattr(widget, "text"):  # QLineEdit, QTextEdit
            current_value = widget.text()
        else:
            current_value = "Valeur non récupérable"

        # Afficher dans un message box
        QtWidgets.QMessageBox.information(
            None,
            "DEBUG Widget",
            f"Type du widget : {widget_type}\nValeur actuelle : {current_value}"
        )
        if hasattr(widget, "setValue"):
            widget.setValue(result)
        elif hasattr(widget, "setText"):
            widget.setText(str(result))
    '''
 
    #field = dialog.findChild(QLineEdit, field_name)
    #field.setText(str(result))
    #form.changeAttribute(field_name,str(result))
    form.setFeature(feat)
    form.refreshFeature()
    dialog.show()
    
    # ne fonctionne pas ...
    #iface.openFeatureForm(layer, feat)
else:
    msg += "\n" + "Sauvegarde impossible, cette couche n’est pas éditable (lecture seule)"
    QtWidgets.QMessageBox.critical(None, "Erreur", msg)
    #raise Exception("Layer non éditable")
